#!/bin/bash
source /var/www/html/traitements/conf/scripts.conf 

cd ${qr2go_dir}
for folder in *; do
	echo ${folder}
	cd ${qr2go_dir}/${folder}
	
	for file in *.JPG; do
		mv ${file} $(echo ${file} | sed 's/.JPG/.jpg/g');
	done

	if [ -e "(12).JPG" ] || [ -e "12.JPG" ] || [ -e "12.jpg" ] || [ -e "(12).jpg" ]; then
		rm "(12).JPG" "12.JPG" "12.jpg" "(12).jpg" 2>/dev/null
	fi
	
	mogrify -thumbnail 640x480 -background white -gravity center -extent 640x480 -format png *.jpg
	ffmpeg -framerate 1/5 -pattern_type glob -i '*.png' -c:v libx264 -r 180 -pix_fmt yuv420p out.mp4
	ffmpeg -i out.mp4 -itsoffset 2.00 -i ${sound_dir}/${song} -map 0:v -map 1:a ${video}.mp4

	rm out.mp4
	rm *.png
	cd ${qr2go_dir}
done
